' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class CheckOut
  Inherits System.Web.UI.Page

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Profile.ProfileCompleted = True Then
      ShoppingCartView1.ReadOnly = True
      lblFirstName.Text = Profile.FirstName
      lblLastName.Text = Profile.LastName
      lblStreet.Text = Profile.Address.Street
      lblZipCode.Text = Profile.Address.ZipCode
      lblCity.Text = Profile.Address.City
      lblCountry.Text = Profile.Address.Country
    Else
      Response.Redirect("~/UserDetails.aspx")
    End If
  End Sub

  Protected Sub btnFinalize_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFinalize.Click
    If Profile.ProfileCompleted = True Then
      Try
        Dim orderAmount As Decimal = ShopManager.ShoppingCart.Total
        Dim theCustomer As Customer = _
          New Customer(CType(Membership.GetUser().ProviderUserKey, Guid), _
          Profile.FirstName, Profile.LastName, Profile.Address.Street, _
          Profile.Address.ZipCode, Profile.Address.City, Profile.Address.Country)
        Dim orderId As Integer = ShopManager.FinalizeOrder(theCustomer)
        Response.Redirect("ThankYou.aspx?OrderNumber=" & _
            orderId.ToString() & "&Total=" & orderAmount.ToString("c"))
      Catch ex As Exception
        lblFailure.Visible = True
        btnFinalize.Visible = False
      End Try
    Else
      Response.Redirect("~/UserDetails.aspx")
    End If
  End Sub
End Class
